//Program To Design the Digtial Chebyshev IIR Filter 
clear;
clc;
close;
Wp = input('Enter the Digital Pass Band Edge Frequency');
Ws = input('Enter the Digital Stop Band Edge Frequency');
T = input('Sampling Interval')
OmegaP = (2/T)*tan(Wp/2)
OmegaS = (2/T)*tan(Ws/2)
Delta1 = input('Enter the Pass Band Ripple');
Delta2 = input('Enter the Stop Band Ripple');
Delta = sqrt(((1/Delta2)^2)-1)
Epsilon = sqrt(((1/Delta1)^2)-1)
N = (acosh(Delta/Epsilon))/(acosh(OmegaS/OmegaP))
N = ceil(N)
OmegaC = OmegaP/((((1/Delta1)^2)-1)^(1/(2*N)))
[pols,gn] = zpch1(N,Epsilon,OmegaP)
Hs = poly(gn,'s','coeff')/real(poly(pols,'s'))
z = poly(0,'z');
Hz = horner(Hs,((2/T)*((z-1)/(z+1))))
HW  =frmag(Hz(2),Hz(3),512);  //Frequency response for 512 points
W = 0:%pi/511:%pi;
a=gca();
a.thickness = 1;
plot(W/%pi,abs(HW),'r')
a.foreground = 1;
a.font_style = 9; 
xgrid(1)
xtitle('Magnitude Response of Chebyshev LPF Filter','Normalized Digital Frequency--->','Magnitude in dB');
//RESULT
//Enter the Digital Pass Band Edge Frequency 0.2*%pi
//Enter the Digital Stop Band Edge Frequency 0.6*%pi
//Sampling Interval 1
// T  =
// 
//    1.  
// OmegaP  =
// 
//    0.6498394  
// OmegaS  =
// 
//    2.7527638  
//Enter the Pass Band Ripple 0.8
//Enter the Stop Band Ripple 0.2
// Delta  =
// 
//    4.8989795  
// Epsilon  =
// 
//    0.75  
// N  =
// 
//    1.2079548  
// N  =
// 
//    2.  
// OmegaC  =
// 
//    0.7503699  
// gn  =
// 
//    0.2815275  
// pols  =
// 
//  - 0.2652958 + 0.5305916i  - 0.2652958 - 0.5305916i  
// Hs  =
// 
//            0.2815275            
//    -------------------------    
//                              2  
//    0.3519094 + 0.5305916s + s   
// Hz  =
// 
//                                       2  
//    0.2815275 + 0.5630550z + 0.2815275z   
//    -----------------------------------   
//                                       2  
//    3.2907261 - 7.2961813z + 5.4130926z   
//-->0.5*0.5629
// ans  =
// 
//    0.28145  
// 
//-->Hz(2)= Hz(2)/5.4130926
// Hz  =
// 
//                                       2  
//    0.0520086 + 0.1040172z + 0.0520086z   
//    -----------------------------------   
//                                       2  
//    3.2907261 - 7.2961813z + 5.4130926z   
// 
//-->Hz(3) = Hz(3)/5.4130926
// Hz  =
// 
//                                       2  
//    0.0520086 + 0.1040172z + 0.0520086z   
//    -----------------------------------   
//                                  2       
//        0.6079198 - 1.3478767z + z        
// 
